import re
import ast

def preparing_code_for_parsing(code):
    special_keywords = ['const ', 'var ', 'let ']
    if 'function main' in code:
        code = code[code.find('function main'):]
        start = code.find('{')
        end = len(code)
        content_inside_outermost_curly_braces = ''
        while start != -1 and end != -1:
            substring = code[start:end]
            nested_count = substring.count('{') - substring.count('}')
            if nested_count == 0:
                end = substring.rfind('}')
                content_inside_outermost_curly_braces = substring[1:end-1].strip()
                break
            else:
                end = start
                start = code.find('{', 0, end - 1)
    else:
        content_inside_outermost_curly_braces = code
        
    content_inside_outermost_curly_braces = content_inside_outermost_curly_braces + "\n"
    content_inside_outermost_curly_braces = content_inside_outermost_curly_braces.replace("`","\'")
    content_inside_outermost_curly_braces = content_inside_outermost_curly_braces.replace("[]","")

    if len(content_inside_outermost_curly_braces) > 0:
        content_inside_outermost_curly_braces = re.sub(r"//.*?\n|/\*.*?\*/", "", content_inside_outermost_curly_braces, flags=re.DOTALL)
        for keyw in special_keywords:
            content_inside_outermost_curly_braces = content_inside_outermost_curly_braces.replace(keyw, "")
        parsed_code_split = [re.sub(r'\s+', ' ', lines.strip().replace('\n', '')) for lines in content_inside_outermost_curly_braces.split(';') ]
        parsed_code = ";\n".join(parsed_code_split)
        return parsed_code
    else:
        return None

# Define a function to extract the api names from the ast nodes
def get_api_names(node):
    # If the node is an attribute access, concatenate the name of the attribute with the name of the value
    if isinstance(node, ast.Attribute):
        return get_api_names(node.value) + "." + node.attr
    # If the node is a call, get the name of the function and ignore the arguments
    elif isinstance(node, ast.Call):
        return get_api_names(node.func)
    # If the node is a name, return the name as it is
    elif isinstance(node, ast.Name):
        return node.id 
    # Otherwise, return an empty string
    else:
        return ""
  
# Define a function to get the list of apis used in a typescript code
def get_apis_used(code):
    # Parse the code as an ast
    tree = ast.parse(code)
    # Initialize an empty list to store the api names
    apis = []
    # Traverse the ast nodes
    for node in ast.walk(tree):
      # If the node is a call or an attribute, get the api name and append it to the list
        if isinstance(node, ast.Call) or isinstance(node, ast.Attribute):
            api = get_api_names(node)
            apis.append(api)
    # Return the list of apis
    apis = list(set(apis))
    # apis = list(set([api.split('.')[-1] for api in apis]))
    return apis